CREATE OR REPLACE FUNCTION createtable()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT * FROM information_schema.columns     
                    WHERE table_name= 'prc_filial_verba_desc_controle' 
                      ) THEN
                         
        RAISE NOTICE 'Tabela já existe' ;
        
    ELSE
		CREATE TABLE public.prc_filial_verba_desc_controle
		(
			cd_emp integer NOT NULL,
			cd_filial integer NOT NULL,
			hostname character varying(100) NOT NULL,
			data_verba_util date,
			vlr_verba_util numeric(10,4) NOT NULL DEFAULT 0,
			CONSTRAINT prc_filial_verba_desc_controle_pkey PRIMARY KEY (cd_emp, cd_filial,hostname)
		)
		WITH (
			OIDS = FALSE
		)
		TABLESPACE pg_default;

		ALTER TABLE public.prc_filial_verba_desc_controle
			OWNER to postgres;     
				RAISE NOTICE 'Tabela criada com sucesso!';
	END IF; 
    
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION createtable()  OWNER TO postgres;
SELECT createtable();
DROP FUNCTION createtable();